<?php
namespace Whuzzz_User_Price;
use Redjasa\Customizer_Base;

class Customizer extends Customizer_Base
{
    public function __construct()
    {
        \Kirki::add_config('whuzzz_user_price_customizer', array(
            'capability' => 'edit_theme_options',
            'option_type' => 'theme_mod',
        ));

        $this->customizer();
    }

    public function customizer()
    {
        $customizer = new Customizer_Base;

         $this->add_section('', array(
            'user_price' => array(esc_attr__('User Price', WHUZZZ_USER_PRICE_DOMAIN)),
        ));

        $section = 'user_price_section';

        $customizer->add_field(array(
            'type' => 'toggle',
            'settings' => 'user_price_on_shop',
            'label' => __('Price on Product Loop', WHUZZZ_USER_PRICE_DOMAIN),
            'description' => __('Show special price on shop page', WHUZZZ_USER_PRICE_DOMAIN),
            'section' => $section,
            'default' => false,
        ));
        $customizer->add_field(array(
            'type' => 'toggle',
            'settings' => 'user_price_on_all_user',
            'label' => __('Show for all users', WHUZZZ_USER_PRICE_DOMAIN),
            'description' => __('Show all special price for all user', WHUZZZ_USER_PRICE_DOMAIN),
            'section' => $section,
            'default' => true,
        ));

    }

}
