<?php
namespace Whuzzz_Checkout_Fields;

use Redjasa\Customizer_Base;

class Customizer extends Customizer_Base
{
    public function __construct()
    {
        \Kirki::add_config('whuzzz_checkout_field_customizer', [
            'capability' => 'edit_theme_options',
            'option_type' => 'theme_mod',
        ]);

        $this->add_checkout();

    }


    public function add_checkout()
    {
        $section = 'woocommerce_checkout';

        $this->add_field([
            'type' => 'select',
            'settings' => 'woocommerce_checkout_field_name',
            'section' => $section,
            'label' => __('Name', 'whuzzz-checkout-field'),
            'default' => 'fullname',
            'priority' => 1,
            'choices' => [
                'fullname' => 'Full Name',
                'dual-name' => 'First Name & Last Name',
            ],
            'partial_refresh'    => [
                'woocommerce_checkout_field_name' => [
                    'selector'        => ".rt-checkout-billing",
                    'render_callback' => function () {
                        return false;
                    },
                ],
            ],
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => 'woocommerce_checkout_field_email',
            'section' => $section,
            'label' => __('Email', 'whuzzz-checkout-field'),
            'default' => 'required',
            'priority' => 1,
            'choices' => [
                'hidden' => 'Hidden',
                'optional' => 'Optional',
                'required' => 'Required',
            ],
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => 'woocommerce_checkout_field_postcode',
            'section' => $section,
            'label' => __('Post Code', 'whuzzz-checkout-field'),
            'default' => 'hidden',
            'priority' => 1,
            'choices' => [
                'hidden' => 'Hidden',
                'optional' => 'Optional',
                'required' => 'Required',
            ],
        ]);
        
        $this->add_field([
            'type' => 'select',
            'settings' => 'woocommerce_checkout_field_notes',
            'section' => $section,
            'label' => __('Notes', 'whuzzz-checkout-field'),
            'default' => 'optional',
            'priority' => 2,
            'choices' => [
                'hidden' => 'Hidden',
                'optional' => 'Optional',
            ],
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => 'woocommerce_checkout_field_country',
            'section' => $section,
            'label' => __('Country', 'whuzzz-checkout-field'),
            'priority' => 7,
            'default' => 'hidden',
            'choices' => [
                'hidden' => 'Hidden',
                'required' => 'Required',
            ],
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => 'woocommerce_checkout_field_state',
            'section' => $section,
            'label' => __('Province', 'whuzzz-checkout-field'),
            'priority' => 7,
            'default' => 'required',
            'choices' => [
                'hidden' => 'Hidden',
                'optional' => 'Optional',
                'required' => 'Required',
            ],
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => 'woocommerce_checkout_field_city',
            'section' => $section,
            'label' => __('City', 'whuzzz-checkout-field'),
            'priority' => 8,
            'default' => 'required',
            'choices' => [
                'hidden' => 'Hidden',
                'optional' => 'Optional',
                'required' => 'Required',
            ],
        ]);

        $this->add_field([
            'type' => 'select',
            'settings' => 'woocommerce_checkout_field_address_1',
            'section' => $section,
            'label' => __('Address line 1 field', 'whuzzz-checkout-field'),
            'default' => 'required',
            'priority' => 9,
            'choices' => [
                'hidden' => 'Hidden',
                'optional' => 'Optional',
                'required' => 'Required',
            ],
        ]);

    }
}
