<?php

namespace Whuzzz_Checkout_Fields;

/**
 * Custom Shipping Field
 *
 * Adds a new phone custom field on the checkout page.
 * @version 1.0.0
 * @since 1.0.0
 */
class Custom_Shipping_Field {

    public function __construct() {
        add_filter('woocommerce_checkout_fields', [$this, 'add_phone_field']);
        add_filter('woocommerce_admin_shipping_fields', [$this, 'admin_shipping_field']);
        add_filter('woocommerce_order_formatted_shipping_address', [$this, 'order_formatted_shipping_address'], 10, 2);
    }

    /**
     * Adds a phone field to the shipping section on the checkout page.
     *
     * @param array $fields The existing checkout fields.
     * @return array Modified checkout fields.
     */
    public function add_phone_field($fields) {
        $fields['shipping']['shipping_phone'] = [
            'label'    => __('Phone', 'woocommerce'),
            'required' => false,
            'class'    => ['form-row-wide'],
            'priority' => 25,
        ];
        return $fields;
    }


    /**
     * Adds the phone field to the admin shipping fields.
     *
     * This field can be edited and saved in the admin order detail page.
     *
     * @param array $fields The existing admin shipping fields.
     * @return array Modified admin shipping fields.
     */
    public function admin_shipping_field($fields) {
        $fields['phone'] = [
            'label' => __('Phone', 'woocommerce'),
            'class' => 'form-field-wide',
        ];
        return $fields;
    }

    /**
     * Adds the phone value to the formatted shipping address.
     *
     * @param array  $address The formatted address.
     * @param object $order   The order object.
     * @return array Modified address with the phone number included.
     */
    public function order_formatted_shipping_address($address, $order) {
        // Get the billing and shipping phone numbers
        $billing_phone  = $order->get_billing_phone();
        $shipping_phone = $order->get_shipping_phone();;

        // Mengambil nama belakang pengiriman
        $last_name = $order->get_shipping_last_name();

        // Determine which phone number to use (prioritize shipping phone if available)
        $phone = !empty($shipping_phone) ? $shipping_phone : $billing_phone;

        // Add the phone number to the last name in the address if the phone number exists
        if (!empty($phone)) {
            $address['last_name'] .= " (Phone: {$phone})";
        }
        
        return $address;
    }
}
