<?php

/**
 * Plugin Name: Whuzzz Checkout Field
 * Description: Plugin optimasi kolom pada halaman checkout
 * Plugin URI:  https://whuzzz.id
 * Version:    1.8.1
 * Author:     Whuzzz Studio
 * Author URI:  https://whuzzz.id
 * Text Domain: whuzzz-checkout-field
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Define plugin constants
define('WHUZZZ_CHECKOUT_FIELD_TEMPLATE', plugin_dir_path(__FILE__));
define('WHUZZZ_CHECKOUT_FIELD_ASSETS', plugin_dir_url(__FILE__));

/*=================================================;
/* LOAD THIS PLUGIN AFTER RETHEME LOAD
/*================================================= */
function wcf_plugin_loaded() {
    // load woocommerce if woocommerce plugin active
    if (class_exists('WooCommerce')) {

        // Require necessary files
        require_once WHUZZZ_CHECKOUT_FIELD_TEMPLATE . '/functions.php';
        require_once WHUZZZ_CHECKOUT_FIELD_TEMPLATE . '/plugin.php';
        require_once WHUZZZ_CHECKOUT_FIELD_TEMPLATE . '/includes/include.php';

        // Initialize the classes
        new Whuzzz_Checkout_Fields\Plugin_Init();
        new Whuzzz_Checkout_Fields\Customizer();
        new Whuzzz_Checkout_Fields\Checkout_Field();
        new Whuzzz_Checkout_Fields\Custom_Shipping_Field();
    }

     // Setup update checker
    $check_update = Puc_v4_Factory::buildUpdateChecker('https://gitlab.com/whuzzz/whuzzz-checkout-field', __FILE__, 'whuzzz-checkout-field');
    $check_update->setBranch('stable_release');

    // Trigger action after plugin is loaded
    do_action('wcf_after_plugin_loaded');
}
add_action('rt_after_setup_theme', 'wcf_plugin_loaded');
