<?php
namespace Dapur_Element\Elementor;

use Elementor\Controls_Manager;
use Dapur_Element\Elementor_Base;
use Dapur_Element\Helper;
use Dapur_Element\HTML;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class Image_Slider extends \Dapur_Element\Elementor_Base
{
    public function get_name()
    {
        return 'dapur-image-slider';
    }

    public function get_title()
    {
        return __('Image Slider', 'dapur-element');
    }

    public function get_icon()
    {
         return 'ate-icon ate-post-slider';

    }

    public function get_categories()
    {
        return ['dapur-element'];

    }

    protected function _register_controls()
    {
        $this->setting_options(); //protected
        $this->setting_content();

        // extend redjasa base
        $this->setting_carousel(array(
            'carousel' => true,
        ));
    }

    protected function setting_options()
    {
        $this->start_controls_section(
            'setting_option',
            [
                'label' => __('Options', 'dapur-element'),
            ]
        );

        $this->add_control(
            'image_size',
            [
                'label' => __('Image Size', 'dapur-element'),
                'type' => Controls_Manager::SELECT,
                'default' => 'large',
                'options' => Helper::get_image_size(),
            ]
        );

        $this->end_controls_section();
    }

    public function setting_content()
    {
        $this->start_controls_section(
            'setting_content',
            [
                'label' => __('Content', 'dapur-element'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => __('Choose Image Desktop', 'dapur-element'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'image_mobile',
            [
                'label' => __('Choose Image Mobile', 'dapur-element'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'title', [
                'label' => __('Title', 'dapur-element'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Title', 'dapur-element'),
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => __('url', 'dapur-element'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'dapur-element'),
                'show_external' => true,
                'label_block' => false,
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'sliders',
            [
                'label' => __('iTEMS', 'dapur-element'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => __('Slide #1', 'dapur-element'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $classes[] = 'ael-slider js-dapur-slider';

        echo HTML::before_slider(array(
            'id' => 'ael-slider-' . $this->get_id(),
            'class' => $classes,
            'items-lg' => $settings['slider_item'],
            'items-md' => $settings['slider_item_tablet'],
            'items-sm' => $settings['slider_item_mobile'],
            'pagination' => $settings['slider_pagination'],
            'gap' => $settings['slider_gap'],
            'nav' => ($settings['slider_nav'] != 'none' && $settings['slider_nav'] != 'header') ? true : false,
            'autoplay' => $settings['slider_auto_play'],
        ));

        echo HTML::open('ael-slider__main owl-carousel');

        foreach ($settings['sliders'] as $key => $slider) {
            include dirname(__FILE__) . '/image-slider-view.php';
        }

        echo HTML::close();

        echo HTML::after_slider();

    }
}
