<?php
namespace Dapur_Element;

class HTML
{

    /**
     * open tag html helper
     * @param  string $tag  [tag html]
     * @param  array  $args [setting]
     * @return [type]       [html]
     */
    public static function open($args = '', $tag = '')
    {
        $tag = !empty($tag) ? $tag : 'div';

        if (is_array($args)) {
            foreach ($args as $key => $attribute) {
                if ($key === 'class') {
                    $data[] = $key . '=' . '"' . join(' ', $attribute) . '"';
                } elseif ($key === 'id') {
                    $data[] = $key . '=' . '"' . $attribute . '"';
                } else {
                    $data[] = 'data-' . $key . '=' . '"' . $attribute . '"';
                }
            }
            $attribute = join(' ', $data);
        } else {
            $attribute = "class='{$args}'";
        }

        return "<{$tag} {$attribute}>";
    }

    /**
     * Close tag helper
     * @param  string $tag  [tag html]
     * @param  string $args [setting]
     * @return [type]       [html]
     */
    public static function close($tag = '', $args = '')
    {
        $tag = !empty($tag) ? $tag : 'div';

        return "</{$tag}>";
    }

    /**
     * open tag slider open
     * @param  array  $args [setting]
     * @return [type]       [html slider]
     */
    public static function before_slider($args = array())
    {
        if (!empty($args['class'])) {
            $classes[] = join(' ', $args['class']);
        }

        if (!empty($args['sync'])) {
            $classes[] = 'ael-slider js-dapur-slider-sync';
        } else {
            $classes[] = 'ael-slider js-dapur-slider';
        }

        $defaults = array(
            'class' => $classes,
            'items-lg' => 4,
            'items-md' => 2,
            'items-sm' => 1,
            'padding' => 1,
            'gap' => 10,
            'loop' => false,
            'autoplay' => true,
            'pagination' => false,
            'nav' => true,
            'lazyLoad' => false,
            'nav-icon-left' => 'fa fa-angle-left',
            'nav-icon-right' => 'fa fa-angle-right',
        );

        $slider = wp_parse_args($args, $defaults);

        return self::open($slider);
    }

    /**
     * Close tag slider
     * @return [type] [html]
     */
    public static function after_slider()
    {
        return "</div>";
    }

    /**
     * Nav slider
     */
    public static function nav_slider()
    {
        echo '<nav class="ael-slider__nav">';
        echo '<a class="ael-slider__prev js-dapur-slider-prev"><i class="fa fa-angle-left"></i>' . __('Prev', 'dapur_blog_domain') . '</a>';
        echo '<a class="ael-slider__next js-dapur-slider-next">' . __('Next', 'dapur_blog_domain') . '<i class="fa fa-angle-right"></i></a>';
        echo '</nav>';
    }

    /**
     * Show pagination
     * @param array $args [setting query]
     * @return ['html']
     */
    public static function pagination($args = array())
    {
        $output = '';

        if ($args['style'] == 'number' && $args['style'] != 'no_pagination') {
            $output = '<div class="rt-pagination">' .
            paginate_links(array(
                'prev_text' => __('<span class="ti-arrow-left"></span>', 'dapur-element'),
                'next_text' => __('<span class="ti-arrow-right"></span>', 'dapur-element'),
            ))
                . '</div>';
        }

        if ($args['style'] == 'loadmore' && $args['style'] != 'no_pagination') {
            $output = '<div class="rt-pagination rt-pagination--loadmore">
	              <div class="rt-pagination__spinner js-' . $args['id'] . '-spinner">
	                  <i class="fas fa-spinner fa-spin fa-3x"></i>
	              </div>
	              <a href="#" data-triger-id="' . $args['id'] . '" class="rt-pagination__button js-dapur-loop-load rt-btn">' . __('Load More', 'dapur_blog_domain') . '</a>
	           </div>';
        }

        return $output;
    }

    /**
     * Header block
     * @param  array  $args [setting]
     * @return [type]       [HTML]
     */
    public static function header_block($args = array())
    {
        $id = !empty($args['id']) ? $args['id'] : '';
        $class = !empty($args['class']) ? $args['class'] : '';

        if (!empty($args['title'])) {
            $output = '<div id="' . $id . '" class="ael-header-block ' . $class . '">';
            $output .= '<h2 class="ael-header-block__title">' . $args['title'] . '</h2>';
            if (!empty($args['nav'])):
                $output .= '<div class="ael-header-block__nav">';
                $output .= '<a class="ael-header-block__prev js-dapur-slider-prev"><i class="fa fa-angle-left"></i></a>';
                $output .= '<a class="ael-header-block__next js-dapur-slider-next"><i class="fa fa-angle-right"></i></a>';
                $output .= '</div>';
            endif;
            $output .= '</div>';

            return $output;
        }
    }

    /**
     * show script tag
     * @param  [type] $args [value]
     * @return [type]       [tag]
     */
    public static function script($args)
    {
        $output = '<script>' . $args . '</script>';

        return $output;
    }
    // end class
}
